#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_OrderedUnitComment : BaseTest 
	{

		private BOL.OrderedUnitComment _tstOUC;
		

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			this._tstOUC = new BOL.OrderedUnitComment();
		}


		[Test]
		public void Ctor_Pass()
		{
			Assert.IsNotNull(this._tstOUC);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void OrderedUnitCommentGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstOUC.OrderedUnitCommentGuid = tstValue;

			Assert.AreEqual(this._tstOUC.OrderedUnitCommentGuid, tstValue);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderedUnitCommentGuid_Fail()
		{
		}
	
		[Test]
		public void OrderedUnitGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstOUC.OrderedUnitGuid = tstValue;

			Assert.AreEqual(this._tstOUC.OrderedUnitGuid, tstValue);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderedUnitGuid_Fail()
		{
		}

			
		[Test]
		public void CannedCommentGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstOUC.CannedCommentGuid = tstValue;

			Assert.AreEqual(this._tstOUC.CannedCommentGuid, tstValue);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CannedCommentGuid_Fail()
		{
		}
			
		[Test]
		public void OrderedUnitCommentText_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstOUC.OrderedUnitCommentText = tstValue;

			Assert.AreEqual(this._tstOUC.OrderedUnitCommentText, tstValue);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderedUnitCommentText_Fail()
		{
		}
					
		[Test]
		public void InitializeBlankOrderedUnitCommentTable_Pass()
		{
			DataTable dtTest = BOL.OrderedUnitComment.InitializeBlankOrderedUnitCommentTable();

			Assert.AreEqual(dtTest.Columns.Count, 5);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnitComment.OrderedUnitCommentGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnitComment.OrderedUnitGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnitComment.CannedCommentGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnitComment.OrderedUnitCommentText));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnitComment.LastUpdateUser));
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InitializeBlankOrderedUnitCommentTable_Fail()
		{
		}
					
		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataTable dtTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedUnit");

			DataRow drTest = dtTest.NewRow();
			
			Assert.AreEqual(drTest, this._tstOUC.LoadDataRowFromThis(drTest));
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

	}
}
#endif





